package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteServiceRequest(
    cluster: Optional[String] = Optional.Absent,
    service: String,
    force: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteServiceRequest = {
    import DeleteServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteServiceRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .service(service: java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteServiceRequest.ReadOnly =
    zio.aws.ecs.model.DeleteServiceRequest.wrap(buildAwsValue())
}
object DeleteServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteServiceRequest =
      zio.aws.ecs.model.DeleteServiceRequest(
        cluster.map(value => value),
        service,
        force.map(value => value)
      )
    def cluster: Optional[String]
    def service: String
    def force: Optional[BoxedBoolean]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getForce: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteServiceRequest
  ) extends zio.aws.ecs.model.DeleteServiceRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val service: String = impl.service(): String
    override val force: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteServiceRequest
  ): zio.aws.ecs.model.DeleteServiceRequest.ReadOnly = new Wrapper(impl)
}
