package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCapacityProviderRequest(
    name: String,
    autoScalingGroupProvider: zio.aws.ecs.model.AutoScalingGroupProvider,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest = {
    import CreateCapacityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest
      .builder()
      .name(name: java.lang.String)
      .autoScalingGroupProvider(autoScalingGroupProvider.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateCapacityProviderRequest.ReadOnly =
    zio.aws.ecs.model.CreateCapacityProviderRequest.wrap(buildAwsValue())
}
object CreateCapacityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateCapacityProviderRequest =
      zio.aws.ecs.model.CreateCapacityProviderRequest(
        name,
        autoScalingGroupProvider.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: String
    def autoScalingGroupProvider
        : zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getAutoScalingGroupProvider: ZIO[
      Any,
      Nothing,
      zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly
    ] = ZIO.succeed(autoScalingGroupProvider)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest
  ) extends zio.aws.ecs.model.CreateCapacityProviderRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val autoScalingGroupProvider
        : zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly =
      zio.aws.ecs.model.AutoScalingGroupProvider
        .wrap(impl.autoScalingGroupProvider())
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest
  ): zio.aws.ecs.model.CreateCapacityProviderRequest.ReadOnly = new Wrapper(
    impl
  )
}
