package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTaskProtectionResponse(
    protectedTasks: Optional[Iterable[zio.aws.ecs.model.ProtectedTask]] =
      Optional.Absent,
    failures: Optional[Iterable[zio.aws.ecs.model.Failure]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse = {
    import UpdateTaskProtectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse
      .builder()
      .optionallyWith(
        protectedTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.protectedTasks)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateTaskProtectionResponse.ReadOnly =
    zio.aws.ecs.model.UpdateTaskProtectionResponse.wrap(buildAwsValue())
}
object UpdateTaskProtectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateTaskProtectionResponse =
      zio.aws.ecs.model.UpdateTaskProtectionResponse(
        protectedTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def protectedTasks: Optional[List[zio.aws.ecs.model.ProtectedTask.ReadOnly]]
    def failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getProtectedTasks
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ProtectedTask.ReadOnly]] =
      AwsError.unwrapOptionField("protectedTasks", protectedTasks)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse
  ) extends zio.aws.ecs.model.UpdateTaskProtectionResponse.ReadOnly {
    override val protectedTasks
        : Optional[List[zio.aws.ecs.model.ProtectedTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protectedTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ProtectedTask.wrap(item)
          }.toList
        )
    override val failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionResponse
  ): zio.aws.ecs.model.UpdateTaskProtectionResponse.ReadOnly = new Wrapper(impl)
}
