package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTasksRequest(
    cluster: Optional[String] = Optional.Absent,
    containerInstance: Optional[String] = Optional.Absent,
    family: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent,
    startedBy: Optional[String] = Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    desiredStatus: Optional[zio.aws.ecs.model.DesiredStatus] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTasksRequest = {
    import ListTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTasksRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(containerInstance.map(value => value: java.lang.String))(
        _.containerInstance
      )
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(desiredStatus.map(value => value.unwrap))(_.desiredStatus)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTasksRequest.ReadOnly =
    zio.aws.ecs.model.ListTasksRequest.wrap(buildAwsValue())
}
object ListTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTasksRequest =
      zio.aws.ecs.model.ListTasksRequest(
        cluster.map(value => value),
        containerInstance.map(value => value),
        family.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        startedBy.map(value => value),
        serviceName.map(value => value),
        desiredStatus.map(value => value),
        launchType.map(value => value)
      )
    def cluster: Optional[String]
    def containerInstance: Optional[String]
    def family: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def startedBy: Optional[String]
    def serviceName: Optional[String]
    def desiredStatus: Optional[zio.aws.ecs.model.DesiredStatus]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstance: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstance", containerInstance)
    def getFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("family", family)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getDesiredStatus: ZIO[Any, AwsError, zio.aws.ecs.model.DesiredStatus] =
      AwsError.unwrapOptionField("desiredStatus", desiredStatus)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksRequest
  ) extends zio.aws.ecs.model.ListTasksRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val containerInstance: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerInstance())
      .map(value => value: String)
    override val family: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.family())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
    override val startedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => value: String)
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val desiredStatus: Optional[zio.aws.ecs.model.DesiredStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredStatus())
        .map(value => zio.aws.ecs.model.DesiredStatus.wrap(value))
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksRequest
  ): zio.aws.ecs.model.ListTasksRequest.ReadOnly = new Wrapper(impl)
}
