package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait EFSTransitEncryption {
  def unwrap: software.amazon.awssdk.services.ecs.model.EFSTransitEncryption
}
object EFSTransitEncryption {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.EFSTransitEncryption
  ): zio.aws.ecs.model.EFSTransitEncryption = value match {
    case software.amazon.awssdk.services.ecs.model.EFSTransitEncryption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.EFSTransitEncryption.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.ecs.model.EFSTransitEncryption.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.EFSTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EFSTransitEncryption =
      software.amazon.awssdk.services.ecs.model.EFSTransitEncryption.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.ecs.model.EFSTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EFSTransitEncryption =
      software.amazon.awssdk.services.ecs.model.EFSTransitEncryption.ENABLED
  }
  case object DISABLED extends zio.aws.ecs.model.EFSTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EFSTransitEncryption =
      software.amazon.awssdk.services.ecs.model.EFSTransitEncryption.DISABLED
  }
}
