package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.PortNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ServiceConnectService(
    portName: String,
    discoveryName: Optional[String] = Optional.Absent,
    clientAliases: Optional[
      Iterable[zio.aws.ecs.model.ServiceConnectClientAlias]
    ] = Optional.Absent,
    ingressPortOverride: Optional[PortNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ServiceConnectService = {
    import ServiceConnectService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ServiceConnectService
      .builder()
      .portName(portName: java.lang.String)
      .optionallyWith(discoveryName.map(value => value: java.lang.String))(
        _.discoveryName
      )
      .optionallyWith(
        clientAliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clientAliases)
      .optionallyWith(
        ingressPortOverride.map(value => PortNumber.unwrap(value): Integer)
      )(_.ingressPortOverride)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ServiceConnectService.ReadOnly =
    zio.aws.ecs.model.ServiceConnectService.wrap(buildAwsValue())
}
object ServiceConnectService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ServiceConnectService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ServiceConnectService =
      zio.aws.ecs.model.ServiceConnectService(
        portName,
        discoveryName.map(value => value),
        clientAliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ingressPortOverride.map(value => value)
      )
    def portName: String
    def discoveryName: Optional[String]
    def clientAliases
        : Optional[List[zio.aws.ecs.model.ServiceConnectClientAlias.ReadOnly]]
    def ingressPortOverride: Optional[PortNumber]
    def getPortName: ZIO[Any, Nothing, String] = ZIO.succeed(portName)
    def getDiscoveryName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("discoveryName", discoveryName)
    def getClientAliases: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ServiceConnectClientAlias.ReadOnly
    ]] = AwsError.unwrapOptionField("clientAliases", clientAliases)
    def getIngressPortOverride: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("ingressPortOverride", ingressPortOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectService
  ) extends zio.aws.ecs.model.ServiceConnectService.ReadOnly {
    override val portName: String = impl.portName(): String
    override val discoveryName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.discoveryName())
      .map(value => value: String)
    override val clientAliases
        : Optional[List[zio.aws.ecs.model.ServiceConnectClientAlias.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientAliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceConnectClientAlias.wrap(item)
          }.toList
        )
    override val ingressPortOverride: Optional[PortNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingressPortOverride())
        .map(value => zio.aws.ecs.model.primitives.PortNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectService
  ): zio.aws.ecs.model.ServiceConnectService.ReadOnly = new Wrapper(impl)
}
