package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAccountSettingResponse(
    setting: Optional[zio.aws.ecs.model.Setting] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse = {
    import PutAccountSettingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse
      .builder()
      .optionallyWith(setting.map(value => value.buildAwsValue()))(_.setting)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly =
    zio.aws.ecs.model.PutAccountSettingResponse.wrap(buildAwsValue())
}
object PutAccountSettingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PutAccountSettingResponse =
      zio.aws.ecs.model
        .PutAccountSettingResponse(setting.map(value => value.asEditable))
    def setting: Optional[zio.aws.ecs.model.Setting.ReadOnly]
    def getSetting: ZIO[Any, AwsError, zio.aws.ecs.model.Setting.ReadOnly] =
      AwsError.unwrapOptionField("setting", setting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse
  ) extends zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly {
    override val setting: Optional[zio.aws.ecs.model.Setting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setting())
        .map(value => zio.aws.ecs.model.Setting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingResponse
  ): zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly = new Wrapper(impl)
}
