package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait PlatformDeviceType {
  def unwrap: software.amazon.awssdk.services.ecs.model.PlatformDeviceType
}
object PlatformDeviceType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.PlatformDeviceType
  ): zio.aws.ecs.model.PlatformDeviceType = value match {
    case software.amazon.awssdk.services.ecs.model.PlatformDeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.PlatformDeviceType.GPU =>
      val r = GPU
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.PlatformDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlatformDeviceType =
      software.amazon.awssdk.services.ecs.model.PlatformDeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object GPU extends zio.aws.ecs.model.PlatformDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlatformDeviceType =
      software.amazon.awssdk.services.ecs.model.PlatformDeviceType.GPU
  }
}
