package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTaskSetResponse(
    taskSet: Optional[zio.aws.ecs.model.TaskSet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse = {
    import CreateTaskSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse
      .builder()
      .optionallyWith(taskSet.map(value => value.buildAwsValue()))(_.taskSet)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly =
    zio.aws.ecs.model.CreateTaskSetResponse.wrap(buildAwsValue())
}
object CreateTaskSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateTaskSetResponse = zio.aws.ecs.model
      .CreateTaskSetResponse(taskSet.map(value => value.asEditable))
    def taskSet: Optional[zio.aws.ecs.model.TaskSet.ReadOnly]
    def getTaskSet: ZIO[Any, AwsError, zio.aws.ecs.model.TaskSet.ReadOnly] =
      AwsError.unwrapOptionField("taskSet", taskSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse
  ) extends zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly {
    override val taskSet: Optional[zio.aws.ecs.model.TaskSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSet())
        .map(value => zio.aws.ecs.model.TaskSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateTaskSetResponse
  ): zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly = new Wrapper(impl)
}
