package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Cluster(
    clusterArn: Optional[String] = Optional.Absent,
    clusterName: Optional[String] = Optional.Absent,
    configuration: Optional[zio.aws.ecs.model.ClusterConfiguration] =
      Optional.Absent,
    status: Optional[String] = Optional.Absent,
    registeredContainerInstancesCount: Optional[Integer] = Optional.Absent,
    runningTasksCount: Optional[Integer] = Optional.Absent,
    pendingTasksCount: Optional[Integer] = Optional.Absent,
    activeServicesCount: Optional[Integer] = Optional.Absent,
    statistics: Optional[Iterable[zio.aws.ecs.model.KeyValuePair]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    settings: Optional[Iterable[zio.aws.ecs.model.ClusterSetting]] =
      Optional.Absent,
    capacityProviders: Optional[Iterable[String]] = Optional.Absent,
    defaultCapacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    attachments: Optional[Iterable[zio.aws.ecs.model.Attachment]] =
      Optional.Absent,
    attachmentsStatus: Optional[String] = Optional.Absent,
    serviceConnectDefaults: Optional[
      zio.aws.ecs.model.ClusterServiceConnectDefaults
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Cluster
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        registeredContainerInstancesCount.map(value => value: java.lang.Integer)
      )(_.registeredContainerInstancesCount)
      .optionallyWith(runningTasksCount.map(value => value: java.lang.Integer))(
        _.runningTasksCount
      )
      .optionallyWith(pendingTasksCount.map(value => value: java.lang.Integer))(
        _.pendingTasksCount
      )
      .optionallyWith(
        activeServicesCount.map(value => value: java.lang.Integer)
      )(_.activeServicesCount)
      .optionallyWith(
        statistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statistics)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultCapacityProviderStrategy)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(attachmentsStatus.map(value => value: java.lang.String))(
        _.attachmentsStatus
      )
      .optionallyWith(
        serviceConnectDefaults.map(value => value.buildAwsValue())
      )(_.serviceConnectDefaults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Cluster.ReadOnly =
    zio.aws.ecs.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Cluster = zio.aws.ecs.model.Cluster(
      clusterArn.map(value => value),
      clusterName.map(value => value),
      configuration.map(value => value.asEditable),
      status.map(value => value),
      registeredContainerInstancesCount.map(value => value),
      runningTasksCount.map(value => value),
      pendingTasksCount.map(value => value),
      activeServicesCount.map(value => value),
      statistics.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      settings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      capacityProviders.map(value => value),
      defaultCapacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      attachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      attachmentsStatus.map(value => value),
      serviceConnectDefaults.map(value => value.asEditable)
    )
    def clusterArn: Optional[String]
    def clusterName: Optional[String]
    def configuration: Optional[zio.aws.ecs.model.ClusterConfiguration.ReadOnly]
    def status: Optional[String]
    def registeredContainerInstancesCount: Optional[Integer]
    def runningTasksCount: Optional[Integer]
    def pendingTasksCount: Optional[Integer]
    def activeServicesCount: Optional[Integer]
    def statistics: Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def settings: Optional[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]]
    def capacityProviders: Optional[List[String]]
    def defaultCapacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def attachments: Optional[List[zio.aws.ecs.model.Attachment.ReadOnly]]
    def attachmentsStatus: Optional[String]
    def serviceConnectDefaults
        : Optional[zio.aws.ecs.model.ClusterServiceConnectDefaults.ReadOnly]
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getRegisteredContainerInstancesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "registeredContainerInstancesCount",
        registeredContainerInstancesCount
      )
    def getRunningTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningTasksCount", runningTasksCount)
    def getPendingTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingTasksCount", pendingTasksCount)
    def getActiveServicesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("activeServicesCount", activeServicesCount)
    def getStatistics
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("statistics", statistics)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSettings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      AwsError.unwrapOptionField("settings", settings)
    def getCapacityProviders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getDefaultCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "defaultCapacityProviderStrategy",
      defaultCapacityProviderStrategy
    )
    def getAttachments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getAttachmentsStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentsStatus", attachmentsStatus)
    def getServiceConnectDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ClusterServiceConnectDefaults.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceConnectDefaults",
      serviceConnectDefaults
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Cluster
  ) extends zio.aws.ecs.model.Cluster.ReadOnly {
    override val clusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: String)
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val configuration
        : Optional[zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.ecs.model.ClusterConfiguration.wrap(value))
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val registeredContainerInstancesCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredContainerInstancesCount())
        .map(value => value: Integer)
    override val runningTasksCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningTasksCount())
      .map(value => value: Integer)
    override val pendingTasksCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingTasksCount())
      .map(value => value: Integer)
    override val activeServicesCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.activeServicesCount())
      .map(value => value: Integer)
    override val statistics
        : Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.KeyValuePair.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val settings
        : Optional[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ClusterSetting.wrap(item)
          }.toList
        )
    override val capacityProviders: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProviders())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val defaultCapacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultCapacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val attachments
        : Optional[List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attachment.wrap(item)
          }.toList
        )
    override val attachmentsStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentsStatus())
      .map(value => value: String)
    override val serviceConnectDefaults
        : Optional[zio.aws.ecs.model.ClusterServiceConnectDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceConnectDefaults())
        .map(value =>
          zio.aws.ecs.model.ClusterServiceConnectDefaults.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Cluster
  ): zio.aws.ecs.model.Cluster.ReadOnly = new Wrapper(impl)
}
