package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateTaskSetRequest(
    cluster: String,
    service: String,
    taskSet: String,
    scale: zio.aws.ecs.model.Scale
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest = {
    import UpdateTaskSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .service(service: java.lang.String)
      .taskSet(taskSet: java.lang.String)
      .scale(scale.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateTaskSetRequest.ReadOnly =
    zio.aws.ecs.model.UpdateTaskSetRequest.wrap(buildAwsValue())
}
object UpdateTaskSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateTaskSetRequest = zio.aws.ecs.model
      .UpdateTaskSetRequest(cluster, service, taskSet, scale.asEditable)
    def cluster: String
    def service: String
    def taskSet: String
    def scale: zio.aws.ecs.model.Scale.ReadOnly
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getTaskSet: ZIO[Any, Nothing, String] = ZIO.succeed(taskSet)
    def getScale: ZIO[Any, Nothing, zio.aws.ecs.model.Scale.ReadOnly] =
      ZIO.succeed(scale)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest
  ) extends zio.aws.ecs.model.UpdateTaskSetRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val service: String = impl.service(): String
    override val taskSet: String = impl.taskSet(): String
    override val scale: zio.aws.ecs.model.Scale.ReadOnly =
      zio.aws.ecs.model.Scale.wrap(impl.scale())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest
  ): zio.aws.ecs.model.UpdateTaskSetRequest.ReadOnly = new Wrapper(impl)
}
