package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait TaskField {
  def unwrap: software.amazon.awssdk.services.ecs.model.TaskField
}
object TaskField {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.TaskField
  ): zio.aws.ecs.model.TaskField = value match {
    case software.amazon.awssdk.services.ecs.model.TaskField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.TaskField.TAGS =>
      val r = TAGS
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.TaskField {
    override def unwrap: software.amazon.awssdk.services.ecs.model.TaskField =
      software.amazon.awssdk.services.ecs.model.TaskField.UNKNOWN_TO_SDK_VERSION
  }
  case object TAGS extends zio.aws.ecs.model.TaskField {
    override def unwrap: software.amazon.awssdk.services.ecs.model.TaskField =
      software.amazon.awssdk.services.ecs.model.TaskField.TAGS
  }
}
