package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DockerVolumeConfiguration(
    scope: Optional[zio.aws.ecs.model.Scope] = Optional.Absent,
    autoprovision: Optional[BoxedBoolean] = Optional.Absent,
    driver: Optional[String] = Optional.Absent,
    driverOpts: Optional[Map[String, String]] = Optional.Absent,
    labels: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration = {
    import DockerVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
      .builder()
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(autoprovision.map(value => value: java.lang.Boolean))(
        _.autoprovision
      )
      .optionallyWith(driver.map(value => value: java.lang.String))(_.driver)
      .optionallyWith(
        driverOpts.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.driverOpts)
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly =
    zio.aws.ecs.model.DockerVolumeConfiguration.wrap(buildAwsValue())
}
object DockerVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DockerVolumeConfiguration =
      zio.aws.ecs.model.DockerVolumeConfiguration(
        scope.map(value => value),
        autoprovision.map(value => value),
        driver.map(value => value),
        driverOpts.map(value => value),
        labels.map(value => value)
      )
    def scope: Optional[zio.aws.ecs.model.Scope]
    def autoprovision: Optional[BoxedBoolean]
    def driver: Optional[String]
    def driverOpts: Optional[Map[String, String]]
    def labels: Optional[Map[String, String]]
    def getScope: ZIO[Any, AwsError, zio.aws.ecs.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
    def getAutoprovision: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("autoprovision", autoprovision)
    def getDriver: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("driver", driver)
    def getDriverOpts: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("driverOpts", driverOpts)
    def getLabels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
  ) extends zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly {
    override val scope: Optional[zio.aws.ecs.model.Scope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.ecs.model.Scope.wrap(value))
    override val autoprovision: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoprovision())
      .map(value => value: BoxedBoolean)
    override val driver: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.driver())
      .map(value => value: String)
    override val driverOpts: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driverOpts())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val labels: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DockerVolumeConfiguration
  ): zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
