package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTasksRequest(
    cluster: Optional[String] = Optional.Absent,
    tasks: Iterable[String],
    include: Optional[Iterable[zio.aws.ecs.model.TaskField]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeTasksRequest = {
    import DescribeTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .tasks(tasks.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeTasksRequest.ReadOnly =
    zio.aws.ecs.model.DescribeTasksRequest.wrap(buildAwsValue())
}
object DescribeTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeTasksRequest =
      zio.aws.ecs.model.DescribeTasksRequest(
        cluster.map(value => value),
        tasks,
        include.map(value => value)
      )
    def cluster: Optional[String]
    def tasks: List[String]
    def include: Optional[List[zio.aws.ecs.model.TaskField]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTasks: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tasks)
    def getInclude: ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskField]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
  ) extends zio.aws.ecs.model.DescribeTasksRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val tasks: List[String] = impl
      .tasks()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val include: Optional[List[zio.aws.ecs.model.TaskField]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.TaskField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
  ): zio.aws.ecs.model.DescribeTasksRequest.ReadOnly = new Wrapper(impl)
}
