package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeCapacityProvidersRequest(
    capacityProviders: Optional[Iterable[String]] = Optional.Absent,
    include: Optional[Iterable[zio.aws.ecs.model.CapacityProviderField]] =
      Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest = {
    import DescribeCapacityProvidersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest
      .builder()
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeCapacityProvidersRequest.ReadOnly =
    zio.aws.ecs.model.DescribeCapacityProvidersRequest.wrap(buildAwsValue())
}
object DescribeCapacityProvidersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeCapacityProvidersRequest =
      zio.aws.ecs.model.DescribeCapacityProvidersRequest(
        capacityProviders.map(value => value),
        include.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def capacityProviders: Optional[List[String]]
    def include: Optional[List[zio.aws.ecs.model.CapacityProviderField]]
    def maxResults: Optional[BoxedInteger]
    def nextToken: Optional[String]
    def getCapacityProviders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getInclude
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.CapacityProviderField]] =
      AwsError.unwrapOptionField("include", include)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest
  ) extends zio.aws.ecs.model.DescribeCapacityProvidersRequest.ReadOnly {
    override val capacityProviders: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProviders())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val include
        : Optional[List[zio.aws.ecs.model.CapacityProviderField]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.CapacityProviderField.wrap(item)
          }.toList
        )
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest
  ): zio.aws.ecs.model.DescribeCapacityProvidersRequest.ReadOnly = new Wrapper(
    impl
  )
}
