package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeploymentAlarms(
    alarmNames: Iterable[String],
    enable: Boolean,
    rollback: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeploymentAlarms = {
    import DeploymentAlarms.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeploymentAlarms
      .builder()
      .alarmNames(alarmNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .enable(enable: java.lang.Boolean)
      .rollback(rollback: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeploymentAlarms.ReadOnly =
    zio.aws.ecs.model.DeploymentAlarms.wrap(buildAwsValue())
}
object DeploymentAlarms {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeploymentAlarms
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeploymentAlarms =
      zio.aws.ecs.model.DeploymentAlarms(alarmNames, enable, rollback)
    def alarmNames: List[String]
    def enable: Boolean
    def rollback: Boolean
    def getAlarmNames: ZIO[Any, Nothing, List[String]] = ZIO.succeed(alarmNames)
    def getEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enable)
    def getRollback: ZIO[Any, Nothing, Boolean] = ZIO.succeed(rollback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentAlarms
  ) extends zio.aws.ecs.model.DeploymentAlarms.ReadOnly {
    override val alarmNames: List[String] = impl
      .alarmNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val enable: Boolean = impl.enable(): Boolean
    override val rollback: Boolean = impl.rollback(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentAlarms
  ): zio.aws.ecs.model.DeploymentAlarms.ReadOnly = new Wrapper(impl)
}
