package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteAccountSettingResponse(
    setting: Optional[zio.aws.ecs.model.Setting] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse = {
    import DeleteAccountSettingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse
      .builder()
      .optionallyWith(setting.map(value => value.buildAwsValue()))(_.setting)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly =
    zio.aws.ecs.model.DeleteAccountSettingResponse.wrap(buildAwsValue())
}
object DeleteAccountSettingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteAccountSettingResponse =
      zio.aws.ecs.model
        .DeleteAccountSettingResponse(setting.map(value => value.asEditable))
    def setting: Optional[zio.aws.ecs.model.Setting.ReadOnly]
    def getSetting: ZIO[Any, AwsError, zio.aws.ecs.model.Setting.ReadOnly] =
      AwsError.unwrapOptionField("setting", setting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse
  ) extends zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly {
    override val setting: Optional[zio.aws.ecs.model.Setting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setting())
        .map(value => zio.aws.ecs.model.Setting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteAccountSettingResponse
  ): zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly = new Wrapper(impl)
}
