package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait SchedulingStrategy {
  def unwrap: software.amazon.awssdk.services.ecs.model.SchedulingStrategy
}
object SchedulingStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.SchedulingStrategy
  ): zio.aws.ecs.model.SchedulingStrategy = value match {
    case software.amazon.awssdk.services.ecs.model.SchedulingStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.SchedulingStrategy.REPLICA =>
      val r = REPLICA
      r
    case software.amazon.awssdk.services.ecs.model.SchedulingStrategy.DAEMON =>
      val r = DAEMON
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.SchedulingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.SchedulingStrategy =
      software.amazon.awssdk.services.ecs.model.SchedulingStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object REPLICA extends zio.aws.ecs.model.SchedulingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.SchedulingStrategy =
      software.amazon.awssdk.services.ecs.model.SchedulingStrategy.REPLICA
  }
  case object DAEMON extends zio.aws.ecs.model.SchedulingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.SchedulingStrategy =
      software.amazon.awssdk.services.ecs.model.SchedulingStrategy.DAEMON
  }
}
