package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.{BoxedInteger, Timestamp, Integer}
import scala.jdk.CollectionConverters._
final case class Service(
    serviceArn: Optional[String] = Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    clusterArn: Optional[String] = Optional.Absent,
    loadBalancers: Optional[Iterable[zio.aws.ecs.model.LoadBalancer]] =
      Optional.Absent,
    serviceRegistries: Optional[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      Optional.Absent,
    status: Optional[String] = Optional.Absent,
    desiredCount: Optional[Integer] = Optional.Absent,
    runningCount: Optional[Integer] = Optional.Absent,
    pendingCount: Optional[Integer] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    platformFamily: Optional[String] = Optional.Absent,
    taskDefinition: Optional[String] = Optional.Absent,
    deploymentConfiguration: Optional[
      zio.aws.ecs.model.DeploymentConfiguration
    ] = Optional.Absent,
    taskSets: Optional[Iterable[zio.aws.ecs.model.TaskSet]] = Optional.Absent,
    deployments: Optional[Iterable[zio.aws.ecs.model.Deployment]] =
      Optional.Absent,
    roleArn: Optional[String] = Optional.Absent,
    events: Optional[Iterable[zio.aws.ecs.model.ServiceEvent]] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = Optional.Absent,
    placementStrategy: Optional[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      Optional.Absent,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    healthCheckGracePeriodSeconds: Optional[BoxedInteger] = Optional.Absent,
    schedulingStrategy: Optional[zio.aws.ecs.model.SchedulingStrategy] =
      Optional.Absent,
    deploymentController: Optional[zio.aws.ecs.model.DeploymentController] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    createdBy: Optional[String] = Optional.Absent,
    enableECSManagedTags: Optional[Boolean] = Optional.Absent,
    propagateTags: Optional[zio.aws.ecs.model.PropagateTags] = Optional.Absent,
    enableExecuteCommand: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Service
      .builder()
      .optionallyWith(serviceArn.map(value => value: java.lang.String))(
        _.serviceArn
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(desiredCount.map(value => value: java.lang.Integer))(
        _.desiredCount
      )
      .optionallyWith(runningCount.map(value => value: java.lang.Integer))(
        _.runningCount
      )
      .optionallyWith(pendingCount.map(value => value: java.lang.Integer))(
        _.pendingCount
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(
        taskSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskSets)
      .optionallyWith(
        deployments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployments)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: java.lang.Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(schedulingStrategy.map(value => value.unwrap))(
        _.schedulingStrategy
      )
      .optionallyWith(deploymentController.map(value => value.buildAwsValue()))(
        _.deploymentController
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Service.ReadOnly =
    zio.aws.ecs.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Service = zio.aws.ecs.model.Service(
      serviceArn.map(value => value),
      serviceName.map(value => value),
      clusterArn.map(value => value),
      loadBalancers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      serviceRegistries.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      status.map(value => value),
      desiredCount.map(value => value),
      runningCount.map(value => value),
      pendingCount.map(value => value),
      launchType.map(value => value),
      capacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      taskDefinition.map(value => value),
      deploymentConfiguration.map(value => value.asEditable),
      taskSets.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      deployments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      roleArn.map(value => value),
      events.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createdAt.map(value => value),
      placementConstraints.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      placementStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      networkConfiguration.map(value => value.asEditable),
      healthCheckGracePeriodSeconds.map(value => value),
      schedulingStrategy.map(value => value),
      deploymentController.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createdBy.map(value => value),
      enableECSManagedTags.map(value => value),
      propagateTags.map(value => value),
      enableExecuteCommand.map(value => value)
    )
    def serviceArn: Optional[String]
    def serviceName: Optional[String]
    def clusterArn: Optional[String]
    def loadBalancers: Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def status: Optional[String]
    def desiredCount: Optional[Integer]
    def runningCount: Optional[Integer]
    def pendingCount: Optional[Integer]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def platformVersion: Optional[String]
    def platformFamily: Optional[String]
    def taskDefinition: Optional[String]
    def deploymentConfiguration
        : Optional[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly]
    def taskSets: Optional[List[zio.aws.ecs.model.TaskSet.ReadOnly]]
    def deployments: Optional[List[zio.aws.ecs.model.Deployment.ReadOnly]]
    def roleArn: Optional[String]
    def events: Optional[List[zio.aws.ecs.model.ServiceEvent.ReadOnly]]
    def createdAt: Optional[Timestamp]
    def placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def healthCheckGracePeriodSeconds: Optional[BoxedInteger]
    def schedulingStrategy: Optional[zio.aws.ecs.model.SchedulingStrategy]
    def deploymentController
        : Optional[zio.aws.ecs.model.DeploymentController.ReadOnly]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def createdBy: Optional[String]
    def enableECSManagedTags: Optional[Boolean]
    def propagateTags: Optional[zio.aws.ecs.model.PropagateTags]
    def enableExecuteCommand: Optional[Boolean]
    def getServiceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getRunningCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getPendingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getTaskSets
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskSet.ReadOnly]] =
      AwsError.unwrapOptionField("taskSets", taskSets)
    def getDeployments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Deployment.ReadOnly]] =
      AwsError.unwrapOptionField("deployments", deployments)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEvents
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceEvent.ReadOnly]] =
      AwsError.unwrapOptionField("events", events)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getSchedulingStrategy
        : ZIO[Any, AwsError, zio.aws.ecs.model.SchedulingStrategy] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
    def getDeploymentController
        : ZIO[Any, AwsError, zio.aws.ecs.model.DeploymentController.ReadOnly] =
      AwsError.unwrapOptionField("deploymentController", deploymentController)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Service
  ) extends zio.aws.ecs.model.Service.ReadOnly {
    override val serviceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArn())
      .map(value => value: String)
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val clusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: String)
    override val loadBalancers
        : Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.LoadBalancer.wrap(item)
          }.toList
        )
    override val serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceRegistries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceRegistry.wrap(item)
          }.toList
        )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val desiredCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredCount())
      .map(value => value: Integer)
    override val runningCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningCount())
      .map(value => value: Integer)
    override val pendingCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingCount())
      .map(value => value: Integer)
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val platformFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformFamily())
      .map(value => value: String)
    override val taskDefinition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinition())
      .map(value => value: String)
    override val deploymentConfiguration
        : Optional[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfiguration())
        .map(value => zio.aws.ecs.model.DeploymentConfiguration.wrap(value))
    override val taskSets: Optional[List[zio.aws.ecs.model.TaskSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.TaskSet.wrap(item)
          }.toList
        )
    override val deployments
        : Optional[List[zio.aws.ecs.model.Deployment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Deployment.wrap(item)
          }.toList
        )
    override val roleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: String)
    override val events
        : Optional[List[zio.aws.ecs.model.ServiceEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceEvent.wrap(item)
          }.toList
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementConstraints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementConstraint.wrap(item)
          }.toList
        )
    override val placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStrategy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementStrategy.wrap(item)
          }.toList
        )
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val healthCheckGracePeriodSeconds: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckGracePeriodSeconds())
        .map(value => value: BoxedInteger)
    override val schedulingStrategy
        : Optional[zio.aws.ecs.model.SchedulingStrategy] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingStrategy())
      .map(value => zio.aws.ecs.model.SchedulingStrategy.wrap(value))
    override val deploymentController
        : Optional[zio.aws.ecs.model.DeploymentController.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentController())
        .map(value => zio.aws.ecs.model.DeploymentController.wrap(value))
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val enableECSManagedTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableECSManagedTags())
      .map(value => value: Boolean)
    override val propagateTags: Optional[zio.aws.ecs.model.PropagateTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagateTags())
        .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val enableExecuteCommand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableExecuteCommand())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Service
  ): zio.aws.ecs.model.Service.ReadOnly = new Wrapper(impl)
}
