package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterTaskDefinitionRequest(taskDefinition: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest = {
    import DeregisterTaskDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest
      .builder()
      .taskDefinition(taskDefinition: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeregisterTaskDefinitionRequest.ReadOnly =
    zio.aws.ecs.model.DeregisterTaskDefinitionRequest.wrap(buildAwsValue())
}
object DeregisterTaskDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeregisterTaskDefinitionRequest =
      zio.aws.ecs.model.DeregisterTaskDefinitionRequest(taskDefinition)
    def taskDefinition: String
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest
  ) extends zio.aws.ecs.model.DeregisterTaskDefinitionRequest.ReadOnly {
    override val taskDefinition: String = impl.taskDefinition(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest
  ): zio.aws.ecs.model.DeregisterTaskDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
