package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateTaskProtectionRequest(
    cluster: String,
    tasks: Iterable[String],
    protectionEnabled: Boolean,
    expiresInMinutes: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest = {
    import UpdateTaskProtectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .tasks(tasks.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .protectionEnabled(protectionEnabled: java.lang.Boolean)
      .optionallyWith(expiresInMinutes.map(value => value: Integer))(
        _.expiresInMinutes
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateTaskProtectionRequest.ReadOnly =
    zio.aws.ecs.model.UpdateTaskProtectionRequest.wrap(buildAwsValue())
}
object UpdateTaskProtectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateTaskProtectionRequest =
      zio.aws.ecs.model.UpdateTaskProtectionRequest(
        cluster,
        tasks,
        protectionEnabled,
        expiresInMinutes.map(value => value)
      )
    def cluster: String
    def tasks: List[String]
    def protectionEnabled: Boolean
    def expiresInMinutes: Optional[BoxedInteger]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getTasks: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tasks)
    def getProtectionEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(protectionEnabled)
    def getExpiresInMinutes: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("expiresInMinutes", expiresInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest
  ) extends zio.aws.ecs.model.UpdateTaskProtectionRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val tasks: List[String] = impl
      .tasks()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val protectionEnabled: Boolean = impl.protectionEnabled(): Boolean
    override val expiresInMinutes: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiresInMinutes())
        .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateTaskProtectionRequest
  ): zio.aws.ecs.model.UpdateTaskProtectionRequest.ReadOnly = new Wrapper(impl)
}
