package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.{BoxedBoolean, BoxedInteger}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateServiceRequest(
    cluster: Optional[String] = Optional.Absent,
    service: String,
    desiredCount: Optional[BoxedInteger] = Optional.Absent,
    taskDefinition: Optional[String] = Optional.Absent,
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    deploymentConfiguration: Optional[
      zio.aws.ecs.model.DeploymentConfiguration
    ] = Optional.Absent,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = Optional.Absent,
    placementStrategy: Optional[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    forceNewDeployment: Optional[Boolean] = Optional.Absent,
    healthCheckGracePeriodSeconds: Optional[BoxedInteger] = Optional.Absent,
    enableExecuteCommand: Optional[BoxedBoolean] = Optional.Absent,
    enableECSManagedTags: Optional[BoxedBoolean] = Optional.Absent,
    loadBalancers: Optional[Iterable[zio.aws.ecs.model.LoadBalancer]] =
      Optional.Absent,
    propagateTags: Optional[zio.aws.ecs.model.PropagateTags] = Optional.Absent,
    serviceRegistries: Optional[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      Optional.Absent,
    serviceConnectConfiguration: Optional[
      zio.aws.ecs.model.ServiceConnectConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .service(service: java.lang.String)
      .optionallyWith(desiredCount.map(value => value: Integer))(_.desiredCount)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(
        forceNewDeployment.map(value => value: java.lang.Boolean)
      )(_.forceNewDeployment)
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(
        serviceConnectConfiguration.map(value => value.buildAwsValue())
      )(_.serviceConnectConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateServiceRequest.ReadOnly =
    zio.aws.ecs.model.UpdateServiceRequest.wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateServiceRequest =
      zio.aws.ecs.model.UpdateServiceRequest(
        cluster.map(value => value),
        service,
        desiredCount.map(value => value),
        taskDefinition.map(value => value),
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deploymentConfiguration.map(value => value.asEditable),
        networkConfiguration.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        forceNewDeployment.map(value => value),
        healthCheckGracePeriodSeconds.map(value => value),
        enableExecuteCommand.map(value => value),
        enableECSManagedTags.map(value => value),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        propagateTags.map(value => value),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceConnectConfiguration.map(value => value.asEditable)
      )
    def cluster: Optional[String]
    def service: String
    def desiredCount: Optional[BoxedInteger]
    def taskDefinition: Optional[String]
    def capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def deploymentConfiguration
        : Optional[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly]
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def platformVersion: Optional[String]
    def forceNewDeployment: Optional[Boolean]
    def healthCheckGracePeriodSeconds: Optional[BoxedInteger]
    def enableExecuteCommand: Optional[BoxedBoolean]
    def enableECSManagedTags: Optional[BoxedBoolean]
    def loadBalancers: Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def propagateTags: Optional[zio.aws.ecs.model.PropagateTags]
    def serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def serviceConnectConfiguration
        : Optional[zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getDesiredCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getForceNewDeployment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceNewDeployment", forceNewDeployment)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getEnableExecuteCommand: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getEnableECSManagedTags: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getServiceConnectConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceConnectConfiguration",
      serviceConnectConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
  ) extends zio.aws.ecs.model.UpdateServiceRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val service: String = impl.service(): String
    override val desiredCount: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredCount())
      .map(value => value: BoxedInteger)
    override val taskDefinition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinition())
      .map(value => value: String)
    override val capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val deploymentConfiguration
        : Optional[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfiguration())
        .map(value => zio.aws.ecs.model.DeploymentConfiguration.wrap(value))
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val placementConstraints
        : Optional[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementConstraints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementConstraint.wrap(item)
          }.toList
        )
    override val placementStrategy
        : Optional[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStrategy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlacementStrategy.wrap(item)
          }.toList
        )
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val forceNewDeployment: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceNewDeployment())
      .map(value => value: Boolean)
    override val healthCheckGracePeriodSeconds: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckGracePeriodSeconds())
        .map(value => value: BoxedInteger)
    override val enableExecuteCommand: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableExecuteCommand())
        .map(value => value: BoxedBoolean)
    override val enableECSManagedTags: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableECSManagedTags())
        .map(value => value: BoxedBoolean)
    override val loadBalancers
        : Optional[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.LoadBalancer.wrap(item)
          }.toList
        )
    override val propagateTags: Optional[zio.aws.ecs.model.PropagateTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagateTags())
        .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val serviceRegistries
        : Optional[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceRegistries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceRegistry.wrap(item)
          }.toList
        )
    override val serviceConnectConfiguration
        : Optional[zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceConnectConfiguration())
        .map(value => zio.aws.ecs.model.ServiceConnectConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
  ): zio.aws.ecs.model.UpdateServiceRequest.ReadOnly = new Wrapper(impl)
}
