package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait SettingName {
  def unwrap: software.amazon.awssdk.services.ecs.model.SettingName
}
object SettingName {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.SettingName
  ): zio.aws.ecs.model.SettingName = value match {
    case software.amazon.awssdk.services.ecs.model.SettingName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.SettingName.SERVICE_LONG_ARN_FORMAT =>
      val r = serviceLongArnFormat
      r
    case software.amazon.awssdk.services.ecs.model.SettingName.TASK_LONG_ARN_FORMAT =>
      val r = taskLongArnFormat
      r
    case software.amazon.awssdk.services.ecs.model.SettingName.CONTAINER_INSTANCE_LONG_ARN_FORMAT =>
      val r = containerInstanceLongArnFormat
      r
    case software.amazon.awssdk.services.ecs.model.SettingName.AWSVPC_TRUNKING =>
      val r = awsvpcTrunking
      r
    case software.amazon.awssdk.services.ecs.model.SettingName.CONTAINER_INSIGHTS =>
      val r = containerInsights
      r
    case software.amazon.awssdk.services.ecs.model.SettingName.FARGATE_FIPS_MODE =>
      val r = fargateFIPSMode
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.SettingName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SettingName =
      software.amazon.awssdk.services.ecs.model.SettingName.UNKNOWN_TO_SDK_VERSION
  }
  case object serviceLongArnFormat extends zio.aws.ecs.model.SettingName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SettingName =
      software.amazon.awssdk.services.ecs.model.SettingName.SERVICE_LONG_ARN_FORMAT
  }
  case object taskLongArnFormat extends zio.aws.ecs.model.SettingName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SettingName =
      software.amazon.awssdk.services.ecs.model.SettingName.TASK_LONG_ARN_FORMAT
  }
  case object containerInstanceLongArnFormat
      extends zio.aws.ecs.model.SettingName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SettingName =
      software.amazon.awssdk.services.ecs.model.SettingName.CONTAINER_INSTANCE_LONG_ARN_FORMAT
  }
  case object awsvpcTrunking extends zio.aws.ecs.model.SettingName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SettingName =
      software.amazon.awssdk.services.ecs.model.SettingName.AWSVPC_TRUNKING
  }
  case object containerInsights extends zio.aws.ecs.model.SettingName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SettingName =
      software.amazon.awssdk.services.ecs.model.SettingName.CONTAINER_INSIGHTS
  }
  case object fargateFIPSMode extends zio.aws.ecs.model.SettingName {
    override def unwrap: software.amazon.awssdk.services.ecs.model.SettingName =
      software.amazon.awssdk.services.ecs.model.SettingName.FARGATE_FIPS_MODE
  }
}
