package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTaskSetsResponse(
    taskSets: Optional[Iterable[zio.aws.ecs.model.TaskSet]] = Optional.Absent,
    failures: Optional[Iterable[zio.aws.ecs.model.Failure]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse = {
    import DescribeTaskSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse
      .builder()
      .optionallyWith(
        taskSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskSets)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly =
    zio.aws.ecs.model.DescribeTaskSetsResponse.wrap(buildAwsValue())
}
object DescribeTaskSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeTaskSetsResponse =
      zio.aws.ecs.model.DescribeTaskSetsResponse(
        taskSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskSets: Optional[List[zio.aws.ecs.model.TaskSet.ReadOnly]]
    def failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getTaskSets
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskSet.ReadOnly]] =
      AwsError.unwrapOptionField("taskSets", taskSets)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse
  ) extends zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly {
    override val taskSets: Optional[List[zio.aws.ecs.model.TaskSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.TaskSet.wrap(item)
          }.toList
        )
    override val failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskSetsResponse
  ): zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly = new Wrapper(impl)
}
