package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import scala.jdk.CollectionConverters._
final case class Deployment(
    id: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    taskDefinition: Optional[String] = Optional.Absent,
    desiredCount: Optional[Integer] = Optional.Absent,
    pendingCount: Optional[Integer] = Optional.Absent,
    runningCount: Optional[Integer] = Optional.Absent,
    failedTasks: Optional[Integer] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    capacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    launchType: Optional[zio.aws.ecs.model.LaunchType] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    platformFamily: Optional[String] = Optional.Absent,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    rolloutState: Optional[zio.aws.ecs.model.DeploymentRolloutState] =
      Optional.Absent,
    rolloutStateReason: Optional[String] = Optional.Absent,
    serviceConnectConfiguration: Optional[
      zio.aws.ecs.model.ServiceConnectConfiguration
    ] = Optional.Absent,
    serviceConnectResources: Optional[
      Iterable[zio.aws.ecs.model.ServiceConnectServiceResource]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Deployment
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(desiredCount.map(value => value: java.lang.Integer))(
        _.desiredCount
      )
      .optionallyWith(pendingCount.map(value => value: java.lang.Integer))(
        _.pendingCount
      )
      .optionallyWith(runningCount.map(value => value: java.lang.Integer))(
        _.runningCount
      )
      .optionallyWith(failedTasks.map(value => value: java.lang.Integer))(
        _.failedTasks
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(rolloutState.map(value => value.unwrap))(_.rolloutState)
      .optionallyWith(rolloutStateReason.map(value => value: java.lang.String))(
        _.rolloutStateReason
      )
      .optionallyWith(
        serviceConnectConfiguration.map(value => value.buildAwsValue())
      )(_.serviceConnectConfiguration)
      .optionallyWith(
        serviceConnectResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceConnectResources)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Deployment.ReadOnly =
    zio.aws.ecs.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Deployment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Deployment = zio.aws.ecs.model.Deployment(
      id.map(value => value),
      status.map(value => value),
      taskDefinition.map(value => value),
      desiredCount.map(value => value),
      pendingCount.map(value => value),
      runningCount.map(value => value),
      failedTasks.map(value => value),
      createdAt.map(value => value),
      updatedAt.map(value => value),
      capacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      launchType.map(value => value),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      networkConfiguration.map(value => value.asEditable),
      rolloutState.map(value => value),
      rolloutStateReason.map(value => value),
      serviceConnectConfiguration.map(value => value.asEditable),
      serviceConnectResources.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Optional[String]
    def status: Optional[String]
    def taskDefinition: Optional[String]
    def desiredCount: Optional[Integer]
    def pendingCount: Optional[Integer]
    def runningCount: Optional[Integer]
    def failedTasks: Optional[Integer]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def launchType: Optional[zio.aws.ecs.model.LaunchType]
    def platformVersion: Optional[String]
    def platformFamily: Optional[String]
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def rolloutState: Optional[zio.aws.ecs.model.DeploymentRolloutState]
    def rolloutStateReason: Optional[String]
    def serviceConnectConfiguration
        : Optional[zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly]
    def serviceConnectResources: Optional[
      List[zio.aws.ecs.model.ServiceConnectServiceResource.ReadOnly]
    ]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getPendingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getRunningCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getFailedTasks: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedTasks", failedTasks)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getRolloutState
        : ZIO[Any, AwsError, zio.aws.ecs.model.DeploymentRolloutState] =
      AwsError.unwrapOptionField("rolloutState", rolloutState)
    def getRolloutStateReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rolloutStateReason", rolloutStateReason)
    def getServiceConnectConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceConnectConfiguration",
      serviceConnectConfiguration
    )
    def getServiceConnectResources: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ServiceConnectServiceResource.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceConnectResources",
      serviceConnectResources
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Deployment
  ) extends zio.aws.ecs.model.Deployment.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val taskDefinition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinition())
      .map(value => value: String)
    override val desiredCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredCount())
      .map(value => value: Integer)
    override val pendingCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingCount())
      .map(value => value: Integer)
    override val runningCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningCount())
      .map(value => value: Integer)
    override val failedTasks: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedTasks())
      .map(value => value: Integer)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val capacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val launchType: Optional[zio.aws.ecs.model.LaunchType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchType())
        .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val platformFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformFamily())
      .map(value => value: String)
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val rolloutState
        : Optional[zio.aws.ecs.model.DeploymentRolloutState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rolloutState())
        .map(value => zio.aws.ecs.model.DeploymentRolloutState.wrap(value))
    override val rolloutStateReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rolloutStateReason())
      .map(value => value: String)
    override val serviceConnectConfiguration
        : Optional[zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceConnectConfiguration())
        .map(value => zio.aws.ecs.model.ServiceConnectConfiguration.wrap(value))
    override val serviceConnectResources: Optional[
      List[zio.aws.ecs.model.ServiceConnectServiceResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceConnectResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ServiceConnectServiceResource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Deployment
  ): zio.aws.ecs.model.Deployment.ReadOnly = new Wrapper(impl)
}
