package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTaskDefinitionsRequest(
    taskDefinitions: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest = {
    import DeleteTaskDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest
      .builder()
      .taskDefinitions(taskDefinitions.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteTaskDefinitionsRequest.ReadOnly =
    zio.aws.ecs.model.DeleteTaskDefinitionsRequest.wrap(buildAwsValue())
}
object DeleteTaskDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteTaskDefinitionsRequest =
      zio.aws.ecs.model.DeleteTaskDefinitionsRequest(taskDefinitions)
    def taskDefinitions: List[String]
    def getTaskDefinitions: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(taskDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest
  ) extends zio.aws.ecs.model.DeleteTaskDefinitionsRequest.ReadOnly {
    override val taskDefinitions: List[String] = impl
      .taskDefinitions()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskDefinitionsRequest
  ): zio.aws.ecs.model.DeleteTaskDefinitionsRequest.ReadOnly = new Wrapper(impl)
}
