package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterServiceConnectDefaults(
    namespace: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaults = {
    import ClusterServiceConnectDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaults
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ClusterServiceConnectDefaults.ReadOnly =
    zio.aws.ecs.model.ClusterServiceConnectDefaults.wrap(buildAwsValue())
}
object ClusterServiceConnectDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ClusterServiceConnectDefaults =
      zio.aws.ecs.model
        .ClusterServiceConnectDefaults(namespace.map(value => value))
    def namespace: Optional[String]
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaults
  ) extends zio.aws.ecs.model.ClusterServiceConnectDefaults.ReadOnly {
    override val namespace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaults
  ): zio.aws.ecs.model.ClusterServiceConnectDefaults.ReadOnly = new Wrapper(
    impl
  )
}
