package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationProtocol {
  def unwrap: software.amazon.awssdk.services.ecs.model.ApplicationProtocol
}
object ApplicationProtocol {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ApplicationProtocol
  ): zio.aws.ecs.model.ApplicationProtocol = value match {
    case software.amazon.awssdk.services.ecs.model.ApplicationProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ApplicationProtocol.HTTP =>
      val r = http
      r
    case software.amazon.awssdk.services.ecs.model.ApplicationProtocol.HTTP2 =>
      val r = http2
      r
    case software.amazon.awssdk.services.ecs.model.ApplicationProtocol.GRPC =>
      val r = grpc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.ApplicationProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ApplicationProtocol =
      software.amazon.awssdk.services.ecs.model.ApplicationProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object http extends zio.aws.ecs.model.ApplicationProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ApplicationProtocol =
      software.amazon.awssdk.services.ecs.model.ApplicationProtocol.HTTP
  }
  case object http2 extends zio.aws.ecs.model.ApplicationProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ApplicationProtocol =
      software.amazon.awssdk.services.ecs.model.ApplicationProtocol.HTTP2
  }
  case object grpc extends zio.aws.ecs.model.ApplicationProtocol {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ApplicationProtocol =
      software.amazon.awssdk.services.ecs.model.ApplicationProtocol.GRPC
  }
}
