package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.{BoxedInteger, BoxedBoolean}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LinuxParameters(
    capabilities: Optional[zio.aws.ecs.model.KernelCapabilities] =
      Optional.Absent,
    devices: Optional[Iterable[zio.aws.ecs.model.Device]] = Optional.Absent,
    initProcessEnabled: Optional[BoxedBoolean] = Optional.Absent,
    sharedMemorySize: Optional[BoxedInteger] = Optional.Absent,
    tmpfs: Optional[Iterable[zio.aws.ecs.model.Tmpfs]] = Optional.Absent,
    maxSwap: Optional[BoxedInteger] = Optional.Absent,
    swappiness: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.LinuxParameters = {
    import LinuxParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.LinuxParameters
      .builder()
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        initProcessEnabled.map(value => value: java.lang.Boolean)
      )(_.initProcessEnabled)
      .optionallyWith(sharedMemorySize.map(value => value: Integer))(
        _.sharedMemorySize
      )
      .optionallyWith(
        tmpfs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tmpfs)
      .optionallyWith(maxSwap.map(value => value: Integer))(_.maxSwap)
      .optionallyWith(swappiness.map(value => value: Integer))(_.swappiness)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.LinuxParameters.ReadOnly =
    zio.aws.ecs.model.LinuxParameters.wrap(buildAwsValue())
}
object LinuxParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.LinuxParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.LinuxParameters =
      zio.aws.ecs.model.LinuxParameters(
        capabilities.map(value => value.asEditable),
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        initProcessEnabled.map(value => value),
        sharedMemorySize.map(value => value),
        tmpfs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxSwap.map(value => value),
        swappiness.map(value => value)
      )
    def capabilities: Optional[zio.aws.ecs.model.KernelCapabilities.ReadOnly]
    def devices: Optional[List[zio.aws.ecs.model.Device.ReadOnly]]
    def initProcessEnabled: Optional[BoxedBoolean]
    def sharedMemorySize: Optional[BoxedInteger]
    def tmpfs: Optional[List[zio.aws.ecs.model.Tmpfs.ReadOnly]]
    def maxSwap: Optional[BoxedInteger]
    def swappiness: Optional[BoxedInteger]
    def getCapabilities
        : ZIO[Any, AwsError, zio.aws.ecs.model.KernelCapabilities.ReadOnly] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getDevices
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Device.ReadOnly]] =
      AwsError.unwrapOptionField("devices", devices)
    def getInitProcessEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("initProcessEnabled", initProcessEnabled)
    def getSharedMemorySize: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("sharedMemorySize", sharedMemorySize)
    def getTmpfs: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tmpfs.ReadOnly]] =
      AwsError.unwrapOptionField("tmpfs", tmpfs)
    def getMaxSwap: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxSwap", maxSwap)
    def getSwappiness: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("swappiness", swappiness)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.LinuxParameters
  ) extends zio.aws.ecs.model.LinuxParameters.ReadOnly {
    override val capabilities
        : Optional[zio.aws.ecs.model.KernelCapabilities.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value => zio.aws.ecs.model.KernelCapabilities.wrap(value))
    override val devices: Optional[List[zio.aws.ecs.model.Device.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Device.wrap(item)
          }.toList
        )
    override val initProcessEnabled: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initProcessEnabled())
        .map(value => value: BoxedBoolean)
    override val sharedMemorySize: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharedMemorySize())
        .map(value => value: BoxedInteger)
    override val tmpfs: Optional[List[zio.aws.ecs.model.Tmpfs.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tmpfs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tmpfs.wrap(item)
          }.toList
        )
    override val maxSwap: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSwap())
      .map(value => value: BoxedInteger)
    override val swappiness: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.swappiness())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.LinuxParameters
  ): zio.aws.ecs.model.LinuxParameters.ReadOnly = new Wrapper(impl)
}
