package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateClusterRequest(
    cluster: String,
    settings: Optional[Iterable[zio.aws.ecs.model.ClusterSetting]] =
      Optional.Absent,
    configuration: Optional[zio.aws.ecs.model.ClusterConfiguration] =
      Optional.Absent,
    serviceConnectDefaults: Optional[
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateClusterRequest = {
    import UpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        serviceConnectDefaults.map(value => value.buildAwsValue())
      )(_.serviceConnectDefaults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateClusterRequest.ReadOnly =
    zio.aws.ecs.model.UpdateClusterRequest.wrap(buildAwsValue())
}
object UpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateClusterRequest =
      zio.aws.ecs.model.UpdateClusterRequest(
        cluster,
        settings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        serviceConnectDefaults.map(value => value.asEditable)
      )
    def cluster: String
    def settings: Optional[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]]
    def configuration: Optional[zio.aws.ecs.model.ClusterConfiguration.ReadOnly]
    def serviceConnectDefaults: Optional[
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly
    ]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getSettings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      AwsError.unwrapOptionField("settings", settings)
    def getConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getServiceConnectDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceConnectDefaults",
      serviceConnectDefaults
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
  ) extends zio.aws.ecs.model.UpdateClusterRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val settings
        : Optional[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ClusterSetting.wrap(item)
          }.toList
        )
    override val configuration
        : Optional[zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.ecs.model.ClusterConfiguration.wrap(value))
    override val serviceConnectDefaults: Optional[
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceConnectDefaults())
      .map(value =>
        zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
  ): zio.aws.ecs.model.UpdateClusterRequest.ReadOnly = new Wrapper(impl)
}
