package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubmitAttachmentStateChangesResponse(
    acknowledgment: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse = {
    import SubmitAttachmentStateChangesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse
      .builder()
      .optionallyWith(acknowledgment.map(value => value: java.lang.String))(
        _.acknowledgment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly =
    zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.wrap(buildAwsValue())
}
object SubmitAttachmentStateChangesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitAttachmentStateChangesResponse =
      zio.aws.ecs.model.SubmitAttachmentStateChangesResponse(
        acknowledgment.map(value => value)
      )
    def acknowledgment: Optional[String]
    def getAcknowledgment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acknowledgment", acknowledgment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse
  ) extends zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly {
    override val acknowledgment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.acknowledgment())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesResponse
  ): zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly =
    new Wrapper(impl)
}
