package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    clusterName: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    settings: Optional[Iterable[zio.aws.ecs.model.ClusterSetting]] =
      Optional.Absent,
    configuration: Optional[zio.aws.ecs.model.ClusterConfiguration] =
      Optional.Absent,
    capacityProviders: Optional[Iterable[String]] = Optional.Absent,
    defaultCapacityProviderStrategy: Optional[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = Optional.Absent,
    serviceConnectDefaults: Optional[
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateClusterRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultCapacityProviderStrategy)
      .optionallyWith(
        serviceConnectDefaults.map(value => value.buildAwsValue())
      )(_.serviceConnectDefaults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateClusterRequest.ReadOnly =
    zio.aws.ecs.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateClusterRequest =
      zio.aws.ecs.model.CreateClusterRequest(
        clusterName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        settings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        capacityProviders.map(value => value),
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceConnectDefaults.map(value => value.asEditable)
      )
    def clusterName: Optional[String]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def settings: Optional[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]]
    def configuration: Optional[zio.aws.ecs.model.ClusterConfiguration.ReadOnly]
    def capacityProviders: Optional[List[String]]
    def defaultCapacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ]
    def serviceConnectDefaults: Optional[
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly
    ]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSettings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      AwsError.unwrapOptionField("settings", settings)
    def getConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getCapacityProviders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getDefaultCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "defaultCapacityProviderStrategy",
      defaultCapacityProviderStrategy
    )
    def getServiceConnectDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceConnectDefaults",
      serviceConnectDefaults
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateClusterRequest
  ) extends zio.aws.ecs.model.CreateClusterRequest.ReadOnly {
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val settings
        : Optional[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.settings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ClusterSetting.wrap(item)
          }.toList
        )
    override val configuration
        : Optional[zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value => zio.aws.ecs.model.ClusterConfiguration.wrap(value))
    override val capacityProviders: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProviders())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val defaultCapacityProviderStrategy: Optional[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultCapacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val serviceConnectDefaults: Optional[
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceConnectDefaults())
      .map(value =>
        zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateClusterRequest
  ): zio.aws.ecs.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
