package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateContainerInstancesStateRequest(
    cluster: Optional[String] = Optional.Absent,
    containerInstances: Iterable[String],
    status: zio.aws.ecs.model.ContainerInstanceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest = {
    import UpdateContainerInstancesStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .containerInstances(containerInstances.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.UpdateContainerInstancesStateRequest.ReadOnly =
    zio.aws.ecs.model.UpdateContainerInstancesStateRequest.wrap(buildAwsValue())
}
object UpdateContainerInstancesStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateContainerInstancesStateRequest =
      zio.aws.ecs.model.UpdateContainerInstancesStateRequest(
        cluster.map(value => value),
        containerInstances,
        status
      )
    def cluster: Optional[String]
    def containerInstances: List[String]
    def status: zio.aws.ecs.model.ContainerInstanceStatus
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstances: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(containerInstances)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.ecs.model.ContainerInstanceStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest
  ) extends zio.aws.ecs.model.UpdateContainerInstancesStateRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val containerInstances: List[String] = impl
      .containerInstances()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val status: zio.aws.ecs.model.ContainerInstanceStatus =
      zio.aws.ecs.model.ContainerInstanceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest
  ): zio.aws.ecs.model.UpdateContainerInstancesStateRequest.ReadOnly =
    new Wrapper(impl)
}
