package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class ProtectedTask(
    taskArn: Optional[String] = Optional.Absent,
    protectionEnabled: Optional[Boolean] = Optional.Absent,
    expirationDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ProtectedTask = {
    import ProtectedTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ProtectedTask
      .builder()
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .optionallyWith(protectionEnabled.map(value => value: java.lang.Boolean))(
        _.protectionEnabled
      )
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ProtectedTask.ReadOnly =
    zio.aws.ecs.model.ProtectedTask.wrap(buildAwsValue())
}
object ProtectedTask {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.ProtectedTask] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ProtectedTask =
      zio.aws.ecs.model.ProtectedTask(
        taskArn.map(value => value),
        protectionEnabled.map(value => value),
        expirationDate.map(value => value)
      )
    def taskArn: Optional[String]
    def protectionEnabled: Optional[Boolean]
    def expirationDate: Optional[Timestamp]
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getProtectionEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("protectionEnabled", protectionEnabled)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ProtectedTask
  ) extends zio.aws.ecs.model.ProtectedTask.ReadOnly {
    override val taskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => value: String)
    override val protectionEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.protectionEnabled())
      .map(value => value: Boolean)
    override val expirationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ProtectedTask
  ): zio.aws.ecs.model.ProtectedTask.ReadOnly = new Wrapper(impl)
}
