package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PortMapping(
    containerPort: Optional[BoxedInteger] = Optional.Absent,
    hostPort: Optional[BoxedInteger] = Optional.Absent,
    protocol: Optional[zio.aws.ecs.model.TransportProtocol] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    appProtocol: Optional[zio.aws.ecs.model.ApplicationProtocol] =
      Optional.Absent,
    containerPortRange: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.PortMapping = {
    import PortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PortMapping
      .builder()
      .optionallyWith(containerPort.map(value => value: Integer))(
        _.containerPort
      )
      .optionallyWith(hostPort.map(value => value: Integer))(_.hostPort)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(appProtocol.map(value => value.unwrap))(_.appProtocol)
      .optionallyWith(containerPortRange.map(value => value: java.lang.String))(
        _.containerPortRange
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PortMapping.ReadOnly =
    zio.aws.ecs.model.PortMapping.wrap(buildAwsValue())
}
object PortMapping {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.PortMapping] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PortMapping =
      zio.aws.ecs.model.PortMapping(
        containerPort.map(value => value),
        hostPort.map(value => value),
        protocol.map(value => value),
        name.map(value => value),
        appProtocol.map(value => value),
        containerPortRange.map(value => value)
      )
    def containerPort: Optional[BoxedInteger]
    def hostPort: Optional[BoxedInteger]
    def protocol: Optional[zio.aws.ecs.model.TransportProtocol]
    def name: Optional[String]
    def appProtocol: Optional[zio.aws.ecs.model.ApplicationProtocol]
    def containerPortRange: Optional[String]
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHostPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("hostPort", hostPort)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ecs.model.TransportProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getAppProtocol
        : ZIO[Any, AwsError, zio.aws.ecs.model.ApplicationProtocol] =
      AwsError.unwrapOptionField("appProtocol", appProtocol)
    def getContainerPortRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerPortRange", containerPortRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PortMapping
  ) extends zio.aws.ecs.model.PortMapping.ReadOnly {
    override val containerPort: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: BoxedInteger)
    override val hostPort: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.hostPort())
      .map(value => value: BoxedInteger)
    override val protocol: Optional[zio.aws.ecs.model.TransportProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.ecs.model.TransportProtocol.wrap(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val appProtocol: Optional[zio.aws.ecs.model.ApplicationProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appProtocol())
        .map(value => zio.aws.ecs.model.ApplicationProtocol.wrap(value))
    override val containerPortRange: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPortRange())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PortMapping
  ): zio.aws.ecs.model.PortMapping.ReadOnly = new Wrapper(impl)
}
