package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTaskSetsRequest(
    cluster: String,
    service: String,
    taskSets: Optional[Iterable[String]] = Optional.Absent,
    include: Optional[Iterable[zio.aws.ecs.model.TaskSetField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest = {
    import DescribeTaskSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .service(service: java.lang.String)
      .optionallyWith(
        taskSets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.taskSets)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeTaskSetsRequest.ReadOnly =
    zio.aws.ecs.model.DescribeTaskSetsRequest.wrap(buildAwsValue())
}
object DescribeTaskSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeTaskSetsRequest =
      zio.aws.ecs.model.DescribeTaskSetsRequest(
        cluster,
        service,
        taskSets.map(value => value),
        include.map(value => value)
      )
    def cluster: String
    def service: String
    def taskSets: Optional[List[String]]
    def include: Optional[List[zio.aws.ecs.model.TaskSetField]]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getTaskSets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("taskSets", taskSets)
    def getInclude: ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskSetField]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest
  ) extends zio.aws.ecs.model.DescribeTaskSetsRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val service: String = impl.service(): String
    override val taskSets: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskSets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val include: Optional[List[zio.aws.ecs.model.TaskSetField]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.TaskSetField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest
  ): zio.aws.ecs.model.DescribeTaskSetsRequest.ReadOnly = new Wrapper(impl)
}
