package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterSetting(
    name: Optional[zio.aws.ecs.model.ClusterSettingName] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ClusterSetting = {
    import ClusterSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ClusterSetting
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ClusterSetting.ReadOnly =
    zio.aws.ecs.model.ClusterSetting.wrap(buildAwsValue())
}
object ClusterSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ClusterSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ClusterSetting = zio.aws.ecs.model
      .ClusterSetting(name.map(value => value), value.map(value => value))
    def name: Optional[zio.aws.ecs.model.ClusterSettingName]
    def value: Optional[String]
    def getName: ZIO[Any, AwsError, zio.aws.ecs.model.ClusterSettingName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ClusterSetting
  ) extends zio.aws.ecs.model.ClusterSetting.ReadOnly {
    override val name: Optional[zio.aws.ecs.model.ClusterSettingName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.ecs.model.ClusterSettingName.wrap(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ClusterSetting
  ): zio.aws.ecs.model.ClusterSetting.ReadOnly = new Wrapper(impl)
}
