package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsVpcConfiguration(
    subnets: Iterable[String],
    securityGroups: Optional[Iterable[String]] = Optional.Absent,
    assignPublicIp: Optional[zio.aws.ecs.model.AssignPublicIp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.AwsVpcConfiguration = {
    import AwsVpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.AwsVpcConfiguration
      .builder()
      .subnets(subnets.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(assignPublicIp.map(value => value.unwrap))(
        _.assignPublicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.AwsVpcConfiguration.ReadOnly =
    zio.aws.ecs.model.AwsVpcConfiguration.wrap(buildAwsValue())
}
object AwsVpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.AwsVpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.AwsVpcConfiguration =
      zio.aws.ecs.model.AwsVpcConfiguration(
        subnets,
        securityGroups.map(value => value),
        assignPublicIp.map(value => value)
      )
    def subnets: List[String]
    def securityGroups: Optional[List[String]]
    def assignPublicIp: Optional[zio.aws.ecs.model.AssignPublicIp]
    def getSubnets: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnets)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getAssignPublicIp
        : ZIO[Any, AwsError, zio.aws.ecs.model.AssignPublicIp] =
      AwsError.unwrapOptionField("assignPublicIp", assignPublicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.AwsVpcConfiguration
  ) extends zio.aws.ecs.model.AwsVpcConfiguration.ReadOnly {
    override val subnets: List[String] = impl
      .subnets()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val securityGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val assignPublicIp: Optional[zio.aws.ecs.model.AssignPublicIp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignPublicIp())
        .map(value => zio.aws.ecs.model.AssignPublicIp.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.AwsVpcConfiguration
  ): zio.aws.ecs.model.AwsVpcConfiguration.ReadOnly = new Wrapper(impl)
}
