package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateServiceResponse(
    service: Optional[zio.aws.ecs.model.Service] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateServiceResponse = {
    import UpdateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateServiceResponse
      .builder()
      .optionallyWith(service.map(value => value.buildAwsValue()))(_.service)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateServiceResponse.ReadOnly =
    zio.aws.ecs.model.UpdateServiceResponse.wrap(buildAwsValue())
}
object UpdateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateServiceResponse = zio.aws.ecs.model
      .UpdateServiceResponse(service.map(value => value.asEditable))
    def service: Optional[zio.aws.ecs.model.Service.ReadOnly]
    def getService: ZIO[Any, AwsError, zio.aws.ecs.model.Service.ReadOnly] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServiceResponse
  ) extends zio.aws.ecs.model.UpdateServiceResponse.ReadOnly {
    override val service: Optional[zio.aws.ecs.model.Service.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.service())
        .map(value => zio.aws.ecs.model.Service.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServiceResponse
  ): zio.aws.ecs.model.UpdateServiceResponse.ReadOnly = new Wrapper(impl)
}
