package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import scala.jdk.CollectionConverters._
final case class TaskDefinition(
    taskDefinitionArn: Optional[String] = Optional.Absent,
    containerDefinitions: Optional[
      Iterable[zio.aws.ecs.model.ContainerDefinition]
    ] = Optional.Absent,
    family: Optional[String] = Optional.Absent,
    taskRoleArn: Optional[String] = Optional.Absent,
    executionRoleArn: Optional[String] = Optional.Absent,
    networkMode: Optional[zio.aws.ecs.model.NetworkMode] = Optional.Absent,
    revision: Optional[Integer] = Optional.Absent,
    volumes: Optional[Iterable[zio.aws.ecs.model.Volume]] = Optional.Absent,
    status: Optional[zio.aws.ecs.model.TaskDefinitionStatus] = Optional.Absent,
    requiresAttributes: Optional[Iterable[zio.aws.ecs.model.Attribute]] =
      Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.ecs.model.TaskDefinitionPlacementConstraint]
    ] = Optional.Absent,
    compatibilities: Optional[Iterable[zio.aws.ecs.model.Compatibility]] =
      Optional.Absent,
    runtimePlatform: Optional[zio.aws.ecs.model.RuntimePlatform] =
      Optional.Absent,
    requiresCompatibilities: Optional[
      Iterable[zio.aws.ecs.model.Compatibility]
    ] = Optional.Absent,
    cpu: Optional[String] = Optional.Absent,
    memory: Optional[String] = Optional.Absent,
    inferenceAccelerators: Optional[
      Iterable[zio.aws.ecs.model.InferenceAccelerator]
    ] = Optional.Absent,
    pidMode: Optional[zio.aws.ecs.model.PidMode] = Optional.Absent,
    ipcMode: Optional[zio.aws.ecs.model.IpcMode] = Optional.Absent,
    proxyConfiguration: Optional[zio.aws.ecs.model.ProxyConfiguration] =
      Optional.Absent,
    registeredAt: Optional[Timestamp] = Optional.Absent,
    deregisteredAt: Optional[Timestamp] = Optional.Absent,
    registeredBy: Optional[String] = Optional.Absent,
    ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.TaskDefinition = {
    import TaskDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.TaskDefinition
      .builder()
      .optionallyWith(taskDefinitionArn.map(value => value: java.lang.String))(
        _.taskDefinitionArn
      )
      .optionallyWith(
        containerDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerDefinitions)
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(taskRoleArn.map(value => value: java.lang.String))(
        _.taskRoleArn
      )
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(networkMode.map(value => value.unwrap))(_.networkMode)
      .optionallyWith(revision.map(value => value: java.lang.Integer))(
        _.revision
      )
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        requiresAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requiresAttributes)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        compatibilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibilitiesWithStrings)
      .optionallyWith(runtimePlatform.map(value => value.buildAwsValue()))(
        _.runtimePlatform
      )
      .optionallyWith(
        requiresCompatibilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.requiresCompatibilitiesWithStrings)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAccelerators)
      .optionallyWith(pidMode.map(value => value.unwrap))(_.pidMode)
      .optionallyWith(ipcMode.map(value => value.unwrap))(_.ipcMode)
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .optionallyWith(
        registeredAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.registeredAt)
      .optionallyWith(
        deregisteredAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.deregisteredAt)
      .optionallyWith(registeredBy.map(value => value: java.lang.String))(
        _.registeredBy
      )
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.TaskDefinition.ReadOnly =
    zio.aws.ecs.model.TaskDefinition.wrap(buildAwsValue())
}
object TaskDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.TaskDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.TaskDefinition =
      zio.aws.ecs.model.TaskDefinition(
        taskDefinitionArn.map(value => value),
        containerDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        family.map(value => value),
        taskRoleArn.map(value => value),
        executionRoleArn.map(value => value),
        networkMode.map(value => value),
        revision.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        requiresAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        compatibilities.map(value => value),
        runtimePlatform.map(value => value.asEditable),
        requiresCompatibilities.map(value => value),
        cpu.map(value => value),
        memory.map(value => value),
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pidMode.map(value => value),
        ipcMode.map(value => value),
        proxyConfiguration.map(value => value.asEditable),
        registeredAt.map(value => value),
        deregisteredAt.map(value => value),
        registeredBy.map(value => value),
        ephemeralStorage.map(value => value.asEditable)
      )
    def taskDefinitionArn: Optional[String]
    def containerDefinitions
        : Optional[List[zio.aws.ecs.model.ContainerDefinition.ReadOnly]]
    def family: Optional[String]
    def taskRoleArn: Optional[String]
    def executionRoleArn: Optional[String]
    def networkMode: Optional[zio.aws.ecs.model.NetworkMode]
    def revision: Optional[Integer]
    def volumes: Optional[List[zio.aws.ecs.model.Volume.ReadOnly]]
    def status: Optional[zio.aws.ecs.model.TaskDefinitionStatus]
    def requiresAttributes: Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def placementConstraints: Optional[
      List[zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly]
    ]
    def compatibilities: Optional[List[zio.aws.ecs.model.Compatibility]]
    def runtimePlatform: Optional[zio.aws.ecs.model.RuntimePlatform.ReadOnly]
    def requiresCompatibilities: Optional[List[zio.aws.ecs.model.Compatibility]]
    def cpu: Optional[String]
    def memory: Optional[String]
    def inferenceAccelerators
        : Optional[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]]
    def pidMode: Optional[zio.aws.ecs.model.PidMode]
    def ipcMode: Optional[zio.aws.ecs.model.IpcMode]
    def proxyConfiguration
        : Optional[zio.aws.ecs.model.ProxyConfiguration.ReadOnly]
    def registeredAt: Optional[Timestamp]
    def deregisteredAt: Optional[Timestamp]
    def registeredBy: Optional[String]
    def ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly]
    def getTaskDefinitionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinitionArn", taskDefinitionArn)
    def getContainerDefinitions: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("containerDefinitions", containerDefinitions)
    def getFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("family", family)
    def getTaskRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskRoleArn", taskRoleArn)
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getNetworkMode: ZIO[Any, AwsError, zio.aws.ecs.model.NetworkMode] =
      AwsError.unwrapOptionField("networkMode", networkMode)
    def getRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("revision", revision)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getStatus: ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinitionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRequiresAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("requiresAttributes", requiresAttributes)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getCompatibilities
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Compatibility]] =
      AwsError.unwrapOptionField("compatibilities", compatibilities)
    def getRuntimePlatform
        : ZIO[Any, AwsError, zio.aws.ecs.model.RuntimePlatform.ReadOnly] =
      AwsError.unwrapOptionField("runtimePlatform", runtimePlatform)
    def getRequiresCompatibilities
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Compatibility]] = AwsError
      .unwrapOptionField("requiresCompatibilities", requiresCompatibilities)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InferenceAccelerator.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceAccelerators", inferenceAccelerators)
    def getPidMode: ZIO[Any, AwsError, zio.aws.ecs.model.PidMode] =
      AwsError.unwrapOptionField("pidMode", pidMode)
    def getIpcMode: ZIO[Any, AwsError, zio.aws.ecs.model.IpcMode] =
      AwsError.unwrapOptionField("ipcMode", ipcMode)
    def getProxyConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ProxyConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
    def getRegisteredAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registeredAt", registeredAt)
    def getDeregisteredAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deregisteredAt", deregisteredAt)
    def getRegisteredBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registeredBy", registeredBy)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.TaskDefinition
  ) extends zio.aws.ecs.model.TaskDefinition.ReadOnly {
    override val taskDefinitionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskDefinitionArn())
      .map(value => value: String)
    override val containerDefinitions
        : Optional[List[zio.aws.ecs.model.ContainerDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ContainerDefinition.wrap(item)
          }.toList
        )
    override val family: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.family())
      .map(value => value: String)
    override val taskRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRoleArn())
      .map(value => value: String)
    override val executionRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => value: String)
    override val networkMode: Optional[zio.aws.ecs.model.NetworkMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkMode())
        .map(value => zio.aws.ecs.model.NetworkMode.wrap(value))
    override val revision: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: Integer)
    override val volumes: Optional[List[zio.aws.ecs.model.Volume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Volume.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.ecs.model.TaskDefinitionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ecs.model.TaskDefinitionStatus.wrap(value))
    override val requiresAttributes
        : Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiresAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attribute.wrap(item)
          }.toList
        )
    override val placementConstraints: Optional[
      List[zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.TaskDefinitionPlacementConstraint.wrap(item)
        }.toList
      )
    override val compatibilities
        : Optional[List[zio.aws.ecs.model.Compatibility]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Compatibility.wrap(item)
          }.toList
        )
    override val runtimePlatform
        : Optional[zio.aws.ecs.model.RuntimePlatform.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimePlatform())
        .map(value => zio.aws.ecs.model.RuntimePlatform.wrap(value))
    override val requiresCompatibilities
        : Optional[List[zio.aws.ecs.model.Compatibility]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiresCompatibilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Compatibility.wrap(item)
          }.toList
        )
    override val cpu: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: String)
    override val memory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: String)
    override val inferenceAccelerators
        : Optional[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceAccelerators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.InferenceAccelerator.wrap(item)
          }.toList
        )
    override val pidMode: Optional[zio.aws.ecs.model.PidMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pidMode())
        .map(value => zio.aws.ecs.model.PidMode.wrap(value))
    override val ipcMode: Optional[zio.aws.ecs.model.IpcMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipcMode())
        .map(value => zio.aws.ecs.model.IpcMode.wrap(value))
    override val proxyConfiguration
        : Optional[zio.aws.ecs.model.ProxyConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxyConfiguration())
        .map(value => zio.aws.ecs.model.ProxyConfiguration.wrap(value))
    override val registeredAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val deregisteredAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deregisteredAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val registeredBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredBy())
      .map(value => value: String)
    override val ephemeralStorage
        : Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemeralStorage())
        .map(value => zio.aws.ecs.model.EphemeralStorage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.TaskDefinition
  ): zio.aws.ecs.model.TaskDefinition.ReadOnly = new Wrapper(impl)
}
