package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTaskDefinitionFamiliesResponse(
    families: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse = {
    import ListTaskDefinitionFamiliesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
      .builder()
      .optionallyWith(
        families.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.families)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly =
    zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.wrap(buildAwsValue())
}
object ListTaskDefinitionFamiliesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse =
      zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse(
        families.map(value => value),
        nextToken.map(value => value)
      )
    def families: Optional[List[String]]
    def nextToken: Optional[String]
    def getFamilies: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("families", families)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
  ) extends zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly {
    override val families: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.families())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
  ): zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly =
    new Wrapper(impl)
}
