package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListServicesByNamespaceResponse(
    serviceArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse = {
    import ListServicesByNamespaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse
      .builder()
      .optionallyWith(
        serviceArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.serviceArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListServicesByNamespaceResponse.ReadOnly =
    zio.aws.ecs.model.ListServicesByNamespaceResponse.wrap(buildAwsValue())
}
object ListServicesByNamespaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListServicesByNamespaceResponse =
      zio.aws.ecs.model.ListServicesByNamespaceResponse(
        serviceArns.map(value => value),
        nextToken.map(value => value)
      )
    def serviceArns: Optional[List[String]]
    def nextToken: Optional[String]
    def getServiceArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("serviceArns", serviceArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse
  ) extends zio.aws.ecs.model.ListServicesByNamespaceResponse.ReadOnly {
    override val serviceArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesByNamespaceResponse
  ): zio.aws.ecs.model.ListServicesByNamespaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
