package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceConnectConfiguration(
    enabled: Boolean,
    namespace: Optional[String] = Optional.Absent,
    services: Optional[Iterable[zio.aws.ecs.model.ServiceConnectService]] =
      Optional.Absent,
    logConfiguration: Optional[zio.aws.ecs.model.LogConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration = {
    import ServiceConnectConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly =
    zio.aws.ecs.model.ServiceConnectConfiguration.wrap(buildAwsValue())
}
object ServiceConnectConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ServiceConnectConfiguration =
      zio.aws.ecs.model.ServiceConnectConfiguration(
        enabled,
        namespace.map(value => value),
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        logConfiguration.map(value => value.asEditable)
      )
    def enabled: Boolean
    def namespace: Optional[String]
    def services
        : Optional[List[zio.aws.ecs.model.ServiceConnectService.ReadOnly]]
    def logConfiguration: Optional[zio.aws.ecs.model.LogConfiguration.ReadOnly]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getNamespace: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getServices: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ServiceConnectService.ReadOnly
    ]] = AwsError.unwrapOptionField("services", services)
    def getLogConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.LogConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("logConfiguration", logConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration
  ) extends zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val namespace: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => value: String)
    override val services
        : Optional[List[zio.aws.ecs.model.ServiceConnectService.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceConnectService.wrap(item)
          }.toList
        )
    override val logConfiguration
        : Optional[zio.aws.ecs.model.LogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value => zio.aws.ecs.model.LogConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration
  ): zio.aws.ecs.model.ServiceConnectConfiguration.ReadOnly = new Wrapper(impl)
}
