package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ClusterServiceConnectDefaultsRequest(namespace: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaultsRequest = {
    import ClusterServiceConnectDefaultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaultsRequest
      .builder()
      .namespace(namespace: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly =
    zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.wrap(buildAwsValue())
}
object ClusterServiceConnectDefaultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest =
      zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest(namespace)
    def namespace: String
    def getNamespace: ZIO[Any, Nothing, String] = ZIO.succeed(namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaultsRequest
  ) extends zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly {
    override val namespace: String = impl.namespace(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ClusterServiceConnectDefaultsRequest
  ): zio.aws.ecs.model.ClusterServiceConnectDefaultsRequest.ReadOnly =
    new Wrapper(impl)
}
