package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingGroupProviderUpdate(
    managedScaling: Optional[zio.aws.ecs.model.ManagedScaling] =
      Optional.Absent,
    managedTerminationProtection: Optional[
      zio.aws.ecs.model.ManagedTerminationProtection
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.AutoScalingGroupProviderUpdate = {
    import AutoScalingGroupProviderUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.AutoScalingGroupProviderUpdate
      .builder()
      .optionallyWith(managedScaling.map(value => value.buildAwsValue()))(
        _.managedScaling
      )
      .optionallyWith(managedTerminationProtection.map(value => value.unwrap))(
        _.managedTerminationProtection
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.AutoScalingGroupProviderUpdate.ReadOnly =
    zio.aws.ecs.model.AutoScalingGroupProviderUpdate.wrap(buildAwsValue())
}
object AutoScalingGroupProviderUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.AutoScalingGroupProviderUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.AutoScalingGroupProviderUpdate =
      zio.aws.ecs.model.AutoScalingGroupProviderUpdate(
        managedScaling.map(value => value.asEditable),
        managedTerminationProtection.map(value => value)
      )
    def managedScaling: Optional[zio.aws.ecs.model.ManagedScaling.ReadOnly]
    def managedTerminationProtection
        : Optional[zio.aws.ecs.model.ManagedTerminationProtection]
    def getManagedScaling
        : ZIO[Any, AwsError, zio.aws.ecs.model.ManagedScaling.ReadOnly] =
      AwsError.unwrapOptionField("managedScaling", managedScaling)
    def getManagedTerminationProtection
        : ZIO[Any, AwsError, zio.aws.ecs.model.ManagedTerminationProtection] =
      AwsError.unwrapOptionField(
        "managedTerminationProtection",
        managedTerminationProtection
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.AutoScalingGroupProviderUpdate
  ) extends zio.aws.ecs.model.AutoScalingGroupProviderUpdate.ReadOnly {
    override val managedScaling
        : Optional[zio.aws.ecs.model.ManagedScaling.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedScaling())
        .map(value => zio.aws.ecs.model.ManagedScaling.wrap(value))
    override val managedTerminationProtection
        : Optional[zio.aws.ecs.model.ManagedTerminationProtection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedTerminationProtection())
        .map(value =>
          zio.aws.ecs.model.ManagedTerminationProtection.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.AutoScalingGroupProviderUpdate
  ): zio.aws.ecs.model.AutoScalingGroupProviderUpdate.ReadOnly = new Wrapper(
    impl
  )
}
