package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Attribute(
    name: String,
    value: Optional[String] = Optional.Absent,
    targetType: Optional[zio.aws.ecs.model.TargetType] = Optional.Absent,
    targetId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Attribute = {
    import Attribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Attribute
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(targetId.map(value => value: java.lang.String))(
        _.targetId
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Attribute.ReadOnly =
    zio.aws.ecs.model.Attribute.wrap(buildAwsValue())
}
object Attribute {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Attribute] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Attribute = zio.aws.ecs.model.Attribute(
      name,
      value.map(value => value),
      targetType.map(value => value),
      targetId.map(value => value)
    )
    def name: String
    def value: Optional[String]
    def targetType: Optional[zio.aws.ecs.model.TargetType]
    def targetId: Optional[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getTargetType: ZIO[Any, AwsError, zio.aws.ecs.model.TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTargetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetId", targetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Attribute
  ) extends zio.aws.ecs.model.Attribute.ReadOnly {
    override val name: String = impl.name(): String
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val targetType: Optional[zio.aws.ecs.model.TargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetType())
        .map(value => zio.aws.ecs.model.TargetType.wrap(value))
    override val targetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Attribute
  ): zio.aws.ecs.model.Attribute.ReadOnly = new Wrapper(impl)
}
