package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NetworkBinding(
    bindIP: Optional[String] = Optional.Absent,
    containerPort: Optional[BoxedInteger] = Optional.Absent,
    hostPort: Optional[BoxedInteger] = Optional.Absent,
    protocol: Optional[zio.aws.ecs.model.TransportProtocol] = Optional.Absent,
    containerPortRange: Optional[String] = Optional.Absent,
    hostPortRange: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.NetworkBinding = {
    import NetworkBinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.NetworkBinding
      .builder()
      .optionallyWith(bindIP.map(value => value: java.lang.String))(_.bindIP)
      .optionallyWith(containerPort.map(value => value: Integer))(
        _.containerPort
      )
      .optionallyWith(hostPort.map(value => value: Integer))(_.hostPort)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(containerPortRange.map(value => value: java.lang.String))(
        _.containerPortRange
      )
      .optionallyWith(hostPortRange.map(value => value: java.lang.String))(
        _.hostPortRange
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.NetworkBinding.ReadOnly =
    zio.aws.ecs.model.NetworkBinding.wrap(buildAwsValue())
}
object NetworkBinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.NetworkBinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.NetworkBinding =
      zio.aws.ecs.model.NetworkBinding(
        bindIP.map(value => value),
        containerPort.map(value => value),
        hostPort.map(value => value),
        protocol.map(value => value),
        containerPortRange.map(value => value),
        hostPortRange.map(value => value)
      )
    def bindIP: Optional[String]
    def containerPort: Optional[BoxedInteger]
    def hostPort: Optional[BoxedInteger]
    def protocol: Optional[zio.aws.ecs.model.TransportProtocol]
    def containerPortRange: Optional[String]
    def hostPortRange: Optional[String]
    def getBindIP: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bindIP", bindIP)
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHostPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("hostPort", hostPort)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ecs.model.TransportProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getContainerPortRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerPortRange", containerPortRange)
    def getHostPortRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostPortRange", hostPortRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.NetworkBinding
  ) extends zio.aws.ecs.model.NetworkBinding.ReadOnly {
    override val bindIP: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bindIP())
      .map(value => value: String)
    override val containerPort: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: BoxedInteger)
    override val hostPort: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.hostPort())
      .map(value => value: BoxedInteger)
    override val protocol: Optional[zio.aws.ecs.model.TransportProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.ecs.model.TransportProtocol.wrap(value))
    override val containerPortRange: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPortRange())
      .map(value => value: String)
    override val hostPortRange: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostPortRange())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.NetworkBinding
  ): zio.aws.ecs.model.NetworkBinding.ReadOnly = new Wrapper(impl)
}
