package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class HealthCheck(
    command: Iterable[String],
    interval: Optional[BoxedInteger] = Optional.Absent,
    timeout: Optional[BoxedInteger] = Optional.Absent,
    retries: Optional[BoxedInteger] = Optional.Absent,
    startPeriod: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.HealthCheck = {
    import HealthCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.HealthCheck
      .builder()
      .command(command.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(interval.map(value => value: Integer))(_.interval)
      .optionallyWith(timeout.map(value => value: Integer))(_.timeout)
      .optionallyWith(retries.map(value => value: Integer))(_.retries)
      .optionallyWith(startPeriod.map(value => value: Integer))(_.startPeriod)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.HealthCheck.ReadOnly =
    zio.aws.ecs.model.HealthCheck.wrap(buildAwsValue())
}
object HealthCheck {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.HealthCheck] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.HealthCheck =
      zio.aws.ecs.model.HealthCheck(
        command,
        interval.map(value => value),
        timeout.map(value => value),
        retries.map(value => value),
        startPeriod.map(value => value)
      )
    def command: List[String]
    def interval: Optional[BoxedInteger]
    def timeout: Optional[BoxedInteger]
    def retries: Optional[BoxedInteger]
    def startPeriod: Optional[BoxedInteger]
    def getCommand: ZIO[Any, Nothing, List[String]] = ZIO.succeed(command)
    def getInterval: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("interval", interval)
    def getTimeout: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getRetries: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("retries", retries)
    def getStartPeriod: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("startPeriod", startPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.HealthCheck
  ) extends zio.aws.ecs.model.HealthCheck.ReadOnly {
    override val command: List[String] = impl
      .command()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val interval: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => value: BoxedInteger)
    override val timeout: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => value: BoxedInteger)
    override val retries: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.retries())
      .map(value => value: BoxedInteger)
    override val startPeriod: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.startPeriod())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.HealthCheck
  ): zio.aws.ecs.model.HealthCheck.ReadOnly = new Wrapper(impl)
}
