package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterTaskDefinitionResponse(
    taskDefinition: Optional[zio.aws.ecs.model.TaskDefinition] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse = {
    import DeregisterTaskDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse
      .builder()
      .optionallyWith(taskDefinition.map(value => value.buildAwsValue()))(
        _.taskDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly =
    zio.aws.ecs.model.DeregisterTaskDefinitionResponse.wrap(buildAwsValue())
}
object DeregisterTaskDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeregisterTaskDefinitionResponse =
      zio.aws.ecs.model.DeregisterTaskDefinitionResponse(
        taskDefinition.map(value => value.asEditable)
      )
    def taskDefinition: Optional[zio.aws.ecs.model.TaskDefinition.ReadOnly]
    def getTaskDefinition
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinition.ReadOnly] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse
  ) extends zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly {
    override val taskDefinition
        : Optional[zio.aws.ecs.model.TaskDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDefinition())
        .map(value => zio.aws.ecs.model.TaskDefinition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionResponse
  ): zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly = new Wrapper(
    impl
  )
}
