package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Resource(
    name: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    doubleValue: Optional[Double] = Optional.Absent,
    longValue: Optional[Long] = Optional.Absent,
    integerValue: Optional[Integer] = Optional.Absent,
    stringSetValue: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Resource
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(longValue.map(value => value: java.lang.Long))(
        _.longValue
      )
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(
        stringSetValue.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stringSetValue)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Resource.ReadOnly =
    zio.aws.ecs.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Resource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Resource = zio.aws.ecs.model.Resource(
      name.map(value => value),
      `type`.map(value => value),
      doubleValue.map(value => value),
      longValue.map(value => value),
      integerValue.map(value => value),
      stringSetValue.map(value => value)
    )
    def name: Optional[String]
    def `type`: Optional[String]
    def doubleValue: Optional[Double]
    def longValue: Optional[Long]
    def integerValue: Optional[Integer]
    def stringSetValue: Optional[List[String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getDoubleValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getLongValue: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getStringSetValue: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stringSetValue", stringSetValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Resource
  ) extends zio.aws.ecs.model.Resource.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val doubleValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.doubleValue())
      .map(value => value: Double)
    override val longValue: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.longValue())
      .map(value => value: Long)
    override val integerValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValue())
      .map(value => value: Integer)
    override val stringSetValue: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.stringSetValue())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Resource
  ): zio.aws.ecs.model.Resource.ReadOnly = new Wrapper(impl)
}
